IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_SCA_Rpt_Resumen]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_SCA_Rpt_Resumen] 
END
GO

CREATE PROCEDURE [dbo].[CP_SCA_Rpt_Resumen]	@pFecha						DATETIME,
											@pMostrar_Entrada_EntSal	VARCHAR(2),
											@pTipo_Filtro				CHAR(1),/*A: Por Acceso. C: Por Controlador*/
											@pId_Accesos				VARCHAR(100),/*Separados por coma (depende de @pTipo_Filtro)*/
											@pId_Controladores			VARCHAR(100)/*Separados por coma (depende de @pTipo_Filtro)*/
AS
BEGIN

CREATE TABlE #Rpt (Titulo VARCHAR(100), Valor VARCHAR(10))

DECLARE	@Titulo							VARCHAR(100)
DECLARE @Fecha_Desde					DATETIME
DECLARE @Fecha_Hasta					DATETIME
DECLARE @Id_Acceso						SMALLINT
DECLARE @Descripcion_Acceso				VARCHAR(20)
DECLARE @Id_Controlador					SMALLINT
DECLARE @Descripcion_Controlador		VARCHAR(100)
DECLARE @Resultado						CHAR(1)
DECLARE @Tipo							CHAR(1)
DECLARE @Cant							INT
DECLARE @Flag_Detallada_x_Hora			TINYINT
DECLARE @posicion						INT
DECLARE @longitud						INT
DECLARE @Id_Controlador_Filtro			SMALLINT
DECLARE @Id_Acceso_Filtro				SMALLINT
CREATE TABLE #Lista_Id_Controladores	(Id_Controlador SMALLINT)
CREATE TABLE #Lista_Id_Accesos			(Id_Acceso		SMALLINT)

IF(CONVERT(DATE, @pFecha) = CONVERT(DATE, GETDATE()))
BEGIN
	SET @Flag_Detallada_x_Hora = 1
END
ELSE
BEGIN
	SET @Flag_Detallada_x_Hora = 0
END


IF(RIGHT(@pId_Controladores, 1) <> ',')
BEGIN
	SET @pId_Controladores = @pId_Controladores + ','
END

IF(RIGHT(@pId_Accesos, 1) <> ',')
BEGIN
	SET @pId_Accesos = @pId_Accesos + ','
END

SET @posicion = 0
SET @longitud = 0

IF(@pTipo_Filtro = 'C')
BEGIN

	WHILE CHARINDEX(',', @pId_Controladores, @posicion + 1) > 0
	BEGIN
		SET @longitud				= CHARINDEX(',', @pId_Controladores, @posicion + 1) - @posicion
		SET @Id_Controlador_Filtro	= CONVERT(SMALLINT, SUBSTRING(@pId_Controladores, @posicion, @longitud))

		INSERT INTO #Lista_Id_Controladores (Id_Controlador) VALUES (@Id_Controlador_Filtro)	

		SET @posicion = CHARINDEX(',', @pId_Controladores, @posicion + @longitud) +1
	END

	INSERT INTO #Lista_Id_Accesos
	SELECT DISTINCT Id_Acceso FROM CD_Controladores WHERE Id_Controlador IN (SELECT Id_Controlador FROM #Lista_Id_Controladores)	
END


IF(@pTipo_Filtro = 'A')
BEGIN
	
	WHILE CHARINDEX(',', @pId_Accesos, @posicion + 1) > 0
	BEGIN
		SET @longitud = CHARINDEX(',', @pId_Accesos, @posicion + 1) - @posicion
		SET @Id_Acceso_Filtro = CONVERT(SMALLINT, SUBSTRING(@pId_Accesos, @posicion, @longitud))

		INSERT INTO #Lista_Id_Accesos (Id_Acceso) VALUES (@Id_Acceso_Filtro)

		SET @posicion = CHARINDEX(',', @pId_Controladores, @posicion + @longitud) +1
	END

	INSERT INTO #Lista_Id_Controladores
	SELECT DISTINCT Id_Controlador FROM CD_Controladores WHERE Id_Acceso IN (SELECT Id_Acceso FROM #Lista_Id_Accesos)
END

IF(@pTipo_Filtro = '')
BEGIN
	INSERT INTO #Lista_Id_Accesos
	SELECT DISTINCT Id_Acceso FROM CD_Accesos

	INSERT INTO #Lista_Id_Controladores
	SELECT DISTINCT Id_Controlador FROM CD_Controladores
END


DECLARE curRpt_CD_ES_Clientes_xAccesos CURSOR FOR
SELECT Id_Acceso, LTRIM(RTRIM(Descripcion)) 
FROM CD_Accesos
WHERE
Id_Acceso IN (SELECT Id_Acceso FROM #Lista_Id_Accesos)
ORDER BY Id_Acceso

OPEN curRpt_CD_ES_Clientes_xAccesos
FETCH NEXT FROM curRpt_CD_ES_Clientes_xAccesos INTO @Id_Acceso, @Descripcion_Acceso
WHILE @@FETCH_STATUS = 0
BEGIN

	SET @Titulo = 'ACCESO: (' + CONVERT(VARCHAR(10), @Id_Acceso) + ') ' + @Descripcion_Acceso
	PRINT @Titulo
	INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

	DECLARE curRpt_CD_ES_Clientes_xAccesos_xControlador CURSOR FOR
	SELECT Id_Controlador, LTRIM(RTRIM(Descripcion))
	FROM CD_Controladores
	WHERE
	Id_Acceso = @Id_Acceso
	AND Id_Controlador IN (SELECT Id_Controlador FROM #Lista_Id_Controladores)
	ORDER BY Id_Controlador

	OPEN curRpt_CD_ES_Clientes_xAccesos_xControlador
	FETCH NEXT FROM curRpt_CD_ES_Clientes_xAccesos_xControlador INTO @Id_Controlador, @Descripcion_Controlador
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @Titulo = '--CONTROLADOR: (' + CONVERT(VARCHAR(10), @Id_Controlador) + ') ' + @Descripcion_Controlador
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

		SET @Titulo = '----Cant. Personas Ingresaron Satisfactoriamente (del dia: ' + CONVERT(VARCHAR(10), @pFecha, 103) + ')'
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

		IF(@Flag_Detallada_x_Hora = 1)
		BEGIN
			SET @Fecha_Desde = DATEADD(Mi, -15, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'E', @Fecha_Desde, @Fecha_Hasta, 1))			
			SET @Titulo = '--------Ult. 15 min.: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -1, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------Ult. hora: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -4, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------Ult. 4 horas: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -8, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------Ult. 8 horas: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)
		END
				
		SET @Fecha_Desde = CONVERT(DATE, @pFecha)
		SET @Fecha_Hasta = DATEADD(Mi, -1, DATEADD(dd, 1, @pFecha))
		SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
		SET @Titulo = '--------TOTAL: '
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)
		
		SET @Titulo = '----------------------------------------------------------------------------'
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

		IF(@pMostrar_Entrada_EntSal = 'ES')
		BEGIN
			SET @Titulo = '----Cant. Personas Salieron Satisfactoriamente (del dia: ' + CONVERT(VARCHAR(10), @pFecha, 103) + ')'
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

			IF(@Flag_Detallada_x_Hora = 1)
			BEGIN
				SET @Fecha_Desde = DATEADD(Mi, -15, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
				SET @Titulo = '--------Ult. 15 min.: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -1, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
				SET @Titulo = '--------Ult. hora: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -4, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
				SET @Titulo = '--------Ult. 4 horas: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -8, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
				SET @Titulo = '--------Ult. 8 horas: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)
			END
				
			SET @Fecha_Desde = CONVERT(DATE, @pFecha)
			SET @Fecha_Hasta = DATEADD(Mi, -1, DATEADD(dd, 1, @pFecha))
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'S', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------TOTAL: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Titulo = '----------------------------------------------------------------------------'
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')
		END
		
		SET @Titulo = '----Cant. Personas (identificadas) que intentaron ingresar y fueron rechazadas (del dia: ' + CONVERT(VARCHAR(10), @pFecha, 103) + ')'
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

		IF(@Flag_Detallada_x_Hora = 1)
		BEGIN
			SET @Fecha_Desde = DATEADD(Mi, -15, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------Ult. 15 min.: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -1, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------Ult. hora: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -4, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------Ult. 4 horas: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -8, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------Ult. 8 horas: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)
		END
				
		SET @Fecha_Desde = CONVERT(DATE, @pFecha)
		SET @Fecha_Hasta = DATEADD(Mi, -1, DATEADD(dd, 1, @pFecha))
		SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 1))
		SET @Titulo = '--------TOTAL: '
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

		SET @Titulo = '----------------------------------------------------------------------------'
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

		IF(@pMostrar_Entrada_EntSal = 'ES')
		BEGIN			
			SET @Titulo = '----Cant. Personas (identificadas) que intentaron salir y fueron rechazadas (del dia: ' + CONVERT(VARCHAR(10), @pFecha, 103) + ')'
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

			IF(@Flag_Detallada_x_Hora = 1)
			BEGIN
				SET @Fecha_Desde = DATEADD(Mi, -15, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
				SET @Titulo = '--------Ult. 15 min.: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -1, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
				SET @Titulo = '--------Ult. hora: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -4, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
				SET @Titulo = '--------Ult. 4 horas: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -8, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
				SET @Titulo = '--------Ult. 8 horas: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)
			END
				
			SET @Fecha_Desde = CONVERT(DATE, @pFecha)
			SET @Fecha_Hasta = DATEADD(Mi, -1, DATEADD(dd, 1, @pFecha))
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 1))
			SET @Titulo = '--------TOTAL: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Titulo = '----------------------------------------------------------------------------'
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')
		END		
		
		SET @Titulo = '----Cant. Personas (no identificadas) que intentaron ingresar y fueron rechazadas (del dia: ' + CONVERT(VARCHAR(10), @pFecha, 103) + ')'
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

		IF(@Flag_Detallada_x_Hora = 1)
		BEGIN
			SET @Fecha_Desde = DATEADD(Mi, -15, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 0))
			SET @Titulo = '--------Ult. 15 min.: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -1, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 0))
			SET @Titulo = '--------Ult. hora: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -4, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 0))
			SET @Titulo = '--------Ult. 4 horas: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Fecha_Desde = DATEADD(HH, -8, @pFecha)
			SET @Fecha_Hasta = @pFecha
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 0))
			SET @Titulo = '--------Ult. 8 horas: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)
		END
				
		SET @Fecha_Desde = CONVERT(DATE, @pFecha)
		SET @Fecha_Hasta = DATEADD(Mi, -1, DATEADD(dd, 1, @pFecha))
		SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'E', @Fecha_Desde, @Fecha_Hasta, 0))
		SET @Titulo = '--------TOTAL: '
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

		SET @Titulo = '----------------------------------------------------------------------------'
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

		IF(@pMostrar_Entrada_EntSal = 'ES')
		BEGIN			
			SET @Titulo = '----Cant. Personas (no identificadas) que intentaron salir y fueron rechazadas (del dia: ' + CONVERT(VARCHAR(10), @pFecha, 103) + ')'
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

			IF(@Flag_Detallada_x_Hora = 1)
			BEGIN
				SET @Fecha_Desde = DATEADD(Mi, -15, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 0))
				SET @Titulo = '--------Ult. 15 min.: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -1, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 0))
				SET @Titulo = '--------Ult. hora: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -4, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 0))
				SET @Titulo = '--------Ult. 4 horas: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

				SET @Fecha_Desde = DATEADD(HH, -8, @pFecha)
				SET @Fecha_Hasta = @pFecha
				SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 0))
				SET @Titulo = '--------Ult. 8 horas: '
				PRINT @Titulo
				INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)
			END
				
			SET @Fecha_Desde = CONVERT(DATE, @pFecha)
			SET @Fecha_Hasta = DATEADD(Mi, -1, DATEADD(dd, 1, @pFecha))
			SET @Cant = (dbo.CF_Rpt_CD_ES_Clientes_Cantidades(@Id_Controlador, 'E', 'S', @Fecha_Desde, @Fecha_Hasta, 0))
			SET @Titulo = '--------TOTAL: '
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, @Cant)

			SET @Titulo = '----------------------------------------------------------------------------'
			PRINT @Titulo
			INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')
		END

		SET @Titulo = '----------------------------------------------------------------------------'
		PRINT @Titulo
		INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')

		FETCH NEXT FROM curRpt_CD_ES_Clientes_xAccesos_xControlador INTO @Id_Controlador, @Descripcion_Controlador
	END
	CLOSE curRpt_CD_ES_Clientes_xAccesos_xControlador
	DEALLOCATE curRpt_CD_ES_Clientes_xAccesos_xControlador

	SET @Titulo = '----------------------------------------------------------------------------'
	PRINT @Titulo
	INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')
	SET @Titulo = '----------------------------------------------------------------------------'
	PRINT @Titulo
	INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')
	SET @Titulo = '----------------------------------------------------------------------------'
	PRINT @Titulo
	INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')
	SET @Titulo = '----------------------------------------------------------------------------'
	PRINT @Titulo
	INSERT INTO #Rpt (Titulo, Valor) VALUES (@Titulo, '')
	

	FETCH NEXT FROM curRpt_CD_ES_Clientes_xAccesos INTO @Id_Acceso, @Descripcion_Acceso
END
CLOSE curRpt_CD_ES_Clientes_xAccesos
DEALLOCATE curRpt_CD_ES_Clientes_xAccesos

SELECT * FROM #Rpt

DROP TABLE #Rpt

END